#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 haskell-lsp-types
version:              0.24.0.0
visibility:           public
id:                   haskell-lsp-types-0.24.0.0-8LOjsh2NsXEBIQN9kYTjJ4
key:                  haskell-lsp-types-0.24.0.0-8LOjsh2NsXEBIQN9kYTjJ4
license:              MIT
copyright:            Alan Zimmerman, 2016-2020
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/alanz/haskell-lsp
synopsis:
    Haskell library for the Microsoft Language Server Protocol, data types

description:
    An implementation of the types to allow language implementors to
    support the Language Server Protocol for their specific language.

category:             Development
abi:                  d5ae145853aa3cf34e31aa1fccdc1dd2
exposed:              True
exposed-modules:
    Language.Haskell.LSP.Types Language.Haskell.LSP.Types.Capabilities
    Language.Haskell.LSP.Types.Constants
    Language.Haskell.LSP.Types.Lens
    Language.Haskell.LSP.Types.MessageFuncs
    Language.Haskell.LSP.Types.Utils

hidden-modules:
    Language.Haskell.LSP.Types.ClientCapabilities
    Language.Haskell.LSP.Types.CodeAction
    Language.Haskell.LSP.Types.Color Language.Haskell.LSP.Types.Command
    Language.Haskell.LSP.Types.Completion
    Language.Haskell.LSP.Types.DataTypesJSON
    Language.Haskell.LSP.Types.Diagnostic
    Language.Haskell.LSP.Types.DocumentFilter
    Language.Haskell.LSP.Types.FoldingRange
    Language.Haskell.LSP.Types.Hover Language.Haskell.LSP.Types.List
    Language.Haskell.LSP.Types.Location
    Language.Haskell.LSP.Types.MarkupContent
    Language.Haskell.LSP.Types.Message
    Language.Haskell.LSP.Types.Progress
    Language.Haskell.LSP.Types.Symbol
    Language.Haskell.LSP.Types.TextDocument
    Language.Haskell.LSP.Types.Uri Language.Haskell.LSP.Types.Window
    Language.Haskell.LSP.Types.WorkspaceEdit
    Language.Haskell.LSP.Types.WorkspaceFolders

import-dirs:          /usr/lib/ghc-9.0.1/site-local/haskell-lsp-types-0.24.0.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/haskell-lsp-types-0.24.0.0
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/haskell-lsp-types-0.24.0.0

hs-libraries:         HShaskell-lsp-types-0.24.0.0-8LOjsh2NsXEBIQN9kYTjJ4
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S base-4.15.0.0 binary-0.8.8.0
    bytestring-0.10.12.1 data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF
    deepseq-1.4.5.0 filepath-1.4.2.1
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV text-1.2.4.1
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu

haddock-interfaces:
    /usr/share/doc/haskell-lsp0-types/html/haskell-lsp-types.haddock

haddock-html:         /usr/share/doc/haskell-lsp0-types/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

