#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 monad-par
version:              0.3.5
visibility:           public
id:                   monad-par-0.3.5-2bFxlPXBqIyDzb7PgnBgVG
key:                  monad-par-0.3.5-2bFxlPXBqIyDzb7PgnBgVG
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2011
maintainer:
    Simon Marlow <marlowsd@gmail.com>, Ryan Newton <rrnewton@gmail.com>

author:               Simon Marlow, Ryan Newton
stability:            Experimental
homepage:             https://github.com/simonmar/monad-par
synopsis:             A library for parallel programming based on a monad
description:
    The '\''Par'\'' monad offers a simple API for parallel programming.  The
    library works for parallelising both pure and @IO@ computations,
    although only the pure version is deterministic.  The default
    implementation provides a work-stealing scheduler and supports
    forking tasks that are much lighter weight than IO-threads.

    For complete documentation see "Control.Monad.Par".

    Some examples of use can be found in the @examples/@ directory of
    the source package.

    Other related packages:

    * @abstract-par@ provides the type classes that abstract over different
    implementations of the @Par@ monad.

    * @monad-par-extras@ provides extra combinators and monad transformers layered on top of
    the @Par@ monad.

    Changes in 0.3.4 relative to 0.3:

    * Fix bugs that cause "thread blocked indefinitely on MVar" crashes.

    * Added "Control.Monad.Par.IO"

category:             Control,Parallelism,Monads
abi:                  357475cacab01d52cb3599925fd03170
exposed:              True
exposed-modules:
    Control.Monad.Par Control.Monad.Par.IO
    Control.Monad.Par.Scheds.Direct Control.Monad.Par.Scheds.Sparks
    Control.Monad.Par.Scheds.Trace
    Control.Monad.Par.Scheds.TraceInternal

hidden-modules:       Control.Monad.Par.Scheds.DirectInternal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/monad-par-0.3.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/monad-par-0.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/monad-par-0.3.5
hs-libraries:         HSmonad-par-0.3.5-2bFxlPXBqIyDzb7PgnBgVG
depends:
    abstract-deque-0.3-rLZkVoavEcHj2UO8hX05l
    abstract-par-0.3.3-JGpg8odfEz949f1LvZszw6 array-0.5.4.0
    base-4.15.0.0 containers-0.6.4.1 deepseq-1.4.5.0
    monad-par-extras-0.3.3-I3db6idFsz1JojkQl47QIh mtl-2.2.2
    mwc-random-0.15.0.2-D48URiuPLNo3NwvGXt3tb6
    parallel-3.2.2.0-G9JTeCQCHda2yggytvFxi6

haddock-interfaces:   /usr/share/doc/haskell-monad-par/html/monad-par.haddock
haddock-html:         /usr/share/doc/haskell-monad-par/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

