#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mueval
version:              0.9.3
visibility:           public
id:                   mueval-0.9.3-LbKnFVKDJiL55uvhhbqiti
key:                  mueval-0.9.3-LbKnFVKDJiL55uvhhbqiti
license:              BSD-3-Clause
maintainer:           Gwern <gwern@gwern.net>
author:               Gwern
homepage:             https://github.com/gwern/mueval
synopsis:             Safely evaluate pure Haskell expressions
description:
    Mueval is a Haskell interpreter. It
    uses the GHC API to evaluate arbitrary Haskell expressions.
    Importantly, mueval takes many precautions to defang and avoid \"evil\"
    code.  It uses resource limits, whitelisted modules and Safe Haskell,
    special Show instances for IO, threads, processes, and changes of directory
    to sandbox the Haskell code.

    It is, in short, intended to be a standalone version of Lambdabot'\''s famous
    evaluation functionality. For examples and explanations, please see the README file.

    Mueval is POSIX-only.

category:             Development, Language
abi:                  8aae93fa50a81391cb60cc8f5c3e6187
exposed:              True
exposed-modules:
    Mueval.ArgsParse Mueval.Context Mueval.Interpreter Mueval.Parallel
    Mueval.Resources

import-dirs:          /usr/lib/ghc-9.0.1/site-local/mueval-0.9.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/mueval-0.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/mueval-0.9.3
hs-libraries:         HSmueval-0.9.3-LbKnFVKDJiL55uvhhbqiti
depends:
    Cabal-3.4.0.0 QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn
    base-4.15.0.0 containers-0.6.4.1 directory-1.3.6.1
    extensible-exceptions-0.1.1.4-78NMIT9qofYFWl0e48Yw92
    filepath-1.4.2.1 hint-0.9.0.4-Cx90noHvcwMCh5ipcQpE4q mtl-2.2.2
    process-1.6.11.0 show-0.6-LQ9xO6xXpCTG3lALD3dLOr
    simple-reflect-0.3.3-Gtodyc0HklS7fcoRZfRAjv unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-mueval/html/mueval.haddock
haddock-html:         /usr/share/doc/haskell-mueval/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

