#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nettle
version:              0.3.0
visibility:           public
id:                   nettle-0.3.0-LBTadu1XgKbBXssreAKwoe
key:                  nettle-0.3.0-LBTadu1XgKbBXssreAKwoe
license:              MIT
copyright:            Stefan Bühler <stbuehler@web.de>
maintainer:           Stefan Bühler <stbuehler@web.de>
author:               Stefan Bühler <stbuehler@web.de>
homepage:             https://github.com/stbuehler/haskell-nettle
synopsis:             safe nettle binding
description:
    safe binding for the nettle (<http://www.lysator.liu.se/~nisse/nettle/nettle.html>) library.
    Tested with 3.4, might work with 3.2 (but not earlier).

category:             Cryptography
abi:                  940b44d690c92a7ac557a10390fd0617
exposed:              True
exposed-modules:
    Crypto.Nettle.CCM Crypto.Nettle.ChaChaPoly1305
    Crypto.Nettle.Ciphers Crypto.Nettle.HMAC Crypto.Nettle.Hash
    Crypto.Nettle.KeyedHash Crypto.Nettle.UMAC

hidden-modules:
    Crypto.Nettle.Ciphers.Internal Crypto.Nettle.Ciphers.ForeignImports
    Crypto.Nettle.Hash.ForeignImports Crypto.Nettle.Hash.Types
    Nettle.Utils

import-dirs:          /usr/lib/ghc-9.0.1/site-local/nettle-0.3.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/nettle-0.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/nettle-0.3.0
hs-libraries:         HSnettle-0.3.0-LBTadu1XgKbBXssreAKwoe
extra-libraries:      nettle
depends:
    base-4.15.0.0 byteable-0.1.1-6a8DqkMpvw66y0umFUx8qQ
    bytestring-0.10.12.1
    crypto-cipher-types-0.0.9-2oAnHtqeRctAMvgq4mBtVl
    securemem-0.1.10-41N9oHXoKmZgzJ7O4ATm5
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25

haddock-interfaces:   /usr/share/doc/haskell-nettle/html/nettle.haddock
haddock-html:         /usr/share/doc/haskell-nettle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

