#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 non-negative
version:              0.1.2
visibility:           public
id:                   non-negative-0.1.2-I6Pwzds4IS5DHzosIdulml
key:                  non-negative-0.1.2-I6Pwzds4IS5DHzosIdulml
license:              LicenseRef-GPL
maintainer:           Henning Thielemann <haskell@henning-thielemann.de>
author:               Henning Thielemann <haskell@henning-thielemann.de>
homepage:             http://code.haskell.org/~thielema/non-negative/
synopsis:             Non-negative numbers
description:
    Provides a class for non-negative numbers,
    a wrapper which can turn any ordered numeric type into a member of that class,
    and a lazy number type for non-negative numbers
    (a generalization of Peano numbers).
    This library is used by the @event-list@ package.

category:             Math
abi:                  ba231cf57f0f5aa5b469f9cbcf3f894b
exposed:              True
exposed-modules:
    Numeric.NonNegative.Chunky Numeric.NonNegative.Class
    Numeric.NonNegative.Wrapper

hidden-modules:       Numeric.NonNegative.ChunkyPrivate
import-dirs:          /usr/lib/ghc-9.0.1/site-local/non-negative-0.1.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/non-negative-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/non-negative-0.1.2
hs-libraries:         HSnon-negative-0.1.2-I6Pwzds4IS5DHzosIdulml
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn base-4.15.0.0
    utility-ht-0.0.16-7zsyGPrROJK5tDhAbtdwk3

haddock-interfaces:
    /usr/share/doc/haskell-non-negative/html/non-negative.haddock

haddock-html:         /usr/share/doc/haskell-non-negative/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

