#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nonce
version:              1.0.7
visibility:           public
id:                   nonce-1.0.7-4CZe8FSyge96dPvjQG24T
key:                  nonce-1.0.7-4CZe8FSyge96dPvjQG24T
license:              BSD-3-Clause
copyright:            (c) 2014 Prowdsponsor
maintainer:           Prowdsponsor <opensource@prowdsponsor.com>
author:               Felipe Lessa <felipe.lessa@prowdsponsor.com>
homepage:             https://github.com/prowdsponsor/nonce
synopsis:             Generate cryptographic nonces.
description:
    According to the Wikipedia, a nonce is an arbitrary number used
    only once in a cryptographic communication.  This package
    contain helper functions for generating nonces.

    There are many kinds of nonces used in different situations.
    It'\''s not guaranteed that by using the nonces from this package
    you won'\''t have any security issues.  Please make sure that the
    nonces generated via this package are usable on your design.

category:             Cryptography
abi:                  a3b29d3f76d6b9dbc224a0a442f96b6d
exposed:              True
exposed-modules:      Crypto.Nonce
import-dirs:          /usr/lib/ghc-9.0.1/site-local/nonce-1.0.7
library-dirs:         /usr/lib/ghc-9.0.1/site-local/nonce-1.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/nonce-1.0.7
hs-libraries:         HSnonce-1.0.7-4CZe8FSyge96dPvjQG24T
depends:
    base-4.15.0.0 base64-bytestring-1.2.1.0-BH3if0BufO51UJ74fSwj5E
    bytestring-0.10.12.1 entropy-0.4.1.7-66OkMQHXKESGwpio7bQXje
    text-1.2.4.1 transformers-0.5.6.2
    unliftio-0.2.20-3mGFrmsbPJ1E5EBhNtXPag
    unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN

haddock-interfaces:   /usr/share/doc/haskell-nonce/html/nonce.haddock
haddock-html:         /usr/share/doc/haskell-nonce/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

