#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgresql-binary
version:              0.12.4.1
visibility:           public
id:                   postgresql-binary-0.12.4.1-4bD1719E11P8gxrCeMc9LP
key:                  postgresql-binary-0.12.4.1-4bD1719E11P8gxrCeMc9LP
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  bc41b10aa04555c2fe7c0fff1ddeb2f1
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.0.1/site-local/postgresql-binary-0.12.4.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/postgresql-binary-0.12.4.1
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/postgresql-binary-0.12.4.1

hs-libraries:         HSpostgresql-binary-0.12.4.1-4bD1719E11P8gxrCeMc9LP
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S base-4.15.0.0
    binary-parser-0.5.7-LE9Ldqr1kYGIB4WdP8ol4g bytestring-0.10.12.1
    bytestring-strict-builder-0.4.5.4-8a684jCF9Di3Vd8kRjFc2o
    containers-0.6.4.1 network-ip-0.3.0.3-8YcKiTutsIXAMwGHr6BeFO
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    uuid-1.3.15-KvcbvB71W377mxUBX2XOE7
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

