#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 quickcheck-instances
version:              0.3.25.2
visibility:           public
id:                   quickcheck-instances-0.3.25.2-IK8SwWmrJuB8yqjbpWXvF1
key:                  quickcheck-instances-0.3.25.2-IK8SwWmrJuB8yqjbpWXvF1
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

    For information on writing a test-suite with Cabal
    see <https://www.haskell.org/cabal/users-guide/developing-packages.html#test-suites>

category:             Testing
abi:                  ac9ae74d9622407ba88d2134b1cb8592
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.These
    Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.0.1/site-local/quickcheck-instances-0.3.25.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/quickcheck-instances-0.3.25.2
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/quickcheck-instances-0.3.25.2

hs-libraries:         HSquickcheck-instances-0.3.25.2-IK8SwWmrJuB8yqjbpWXvF1
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn array-0.5.4.0
    base-4.15.0.0 bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR containers-0.6.4.1
    data-fix-0.3.2-FIAjuUl9RSe337ThPKUScQ
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    integer-logarithms-1.0.3.1-2aDPDo9uecRBlUQZ3qjecW
    old-time-1.1.0.3-K1bOYVfsfw9D9troqm7gA3
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV
    splitmix-0.1.0.4-6RoYfMDZXqv3SytCRSWTFr
    strict-0.4.0.1-55b4WQNt0vl9Wflfk1WBTY
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25 text-1.2.4.1
    these-1.1.1.1-deKYvIFkgpB6gZitfRgol time-1.9.3
    time-compat-1.9.6.1-GufUYKky9zLI7r7OltqBbP transformers-0.5.6.2
    transformers-compat-0.7.1-27E2wCklav6CMkj1Ns7rzE
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    uuid-types-1.0.5-9N00rVcWF8YLV2BbcRzeDM
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

