#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ral
version:              0.2
visibility:           public
id:                   ral-0.2-Ds1qQuELZafVGvt6NAeI8
key:                  ral-0.2-Ds1qQuELZafVGvt6NAeI8
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    This packages don'\''t provide length-indexed variant, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  817ef41e1426bcc8957be77c1369f3db
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.0.1/site-local/ral-0.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/ral-0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/ral-0.2
hs-libraries:         HSral-0.2-Ds1qQuELZafVGvt6NAeI8
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn
    adjunctions-4.4-91amTzoWD9ZIz6IvPvuCXl base-4.15.0.0
    bin-0.1.1-F9LjfYUUvIkKhfbKqJbLTX deepseq-1.4.5.0
    distributive-0.6.2.1-Am5w0QbIYNjCC0H1ExagzD
    fin-0.2-6Rv3uOyifwfAnZruGlA0S
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    semigroupoids-5.3.6-8YyLw1xUGcxBRUiDY7goKe

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

