#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 random-source
version:              0.3.0.11
visibility:           public
id:                   random-source-0.3.0.11-6UaMpOcBFZU7W0wDpVN8BW
key:                  random-source-0.3.0.11-6UaMpOcBFZU7W0wDpVN8BW
license:              LicenseRef-PublicDomain
maintainer:           James Cook <mokus@deepbondi.net>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/mokus0/random-fu
synopsis:             Generic basis for random number generators
description:
    Random number generation based on entropy sources
    able to produce a small but well-defined set of
    primitive variates.  Also includes facilities for
    \"completing\" partial implementations, making it
    easy to define new entropy sources in a way that
    is naturally forward-compatible.

category:             Math
abi:                  91c0ca1f2b4dc8b073f1f4e2b6fec8c0
exposed:              True
exposed-modules:
    Data.Random.Internal.Source Data.Random.Internal.Words
    Data.Random.Source Data.Random.Source.DevRandom
    Data.Random.Source.IO Data.Random.Source.MWC
    Data.Random.Source.PureMT Data.Random.Source.Std
    Data.Random.Source.StdGen

hidden-modules:
    Data.Random.Source.Internal.Prim Data.Random.Source.Internal.TH

import-dirs:          /usr/lib/ghc-9.0.1/site-local/random-source-0.3.0.11
library-dirs:         /usr/lib/ghc-9.0.1/site-local/random-source-0.3.0.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/random-source-0.3.0.11
hs-libraries:         HSrandom-source-0.3.0.11-6UaMpOcBFZU7W0wDpVN8BW
depends:
    base-4.15.0.0 flexible-defaults-0.0.3-IXEOqgzYbLYFKcZwd8XFVA
    mersenne-random-pure64-0.2.2.0-2UuOWsdvJayBT8ioBdiH4S mtl-2.2.2
    mwc-random-0.15.0.2-D48URiuPLNo3NwvGXt3tb6
    primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR
    stateref-0.3-Jp7AuxKnQwJEjEJAudyXqA
    syb-0.7.2.1-JG4kH6P0JxMKeIFdjWhhC8 template-haskell-2.17.0.0
    th-extras-0.0.0.4-LPr6VXdlXJALD1UP0M4p5f

haddock-interfaces:
    /usr/share/doc/haskell-random-source/html/random-source.haddock

haddock-html:         /usr/share/doc/haskell-random-source/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

