#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 Ranged-sets
version:              0.4.0
visibility:           public
id:                   Ranged-sets-0.4.0-LxdXSIdHskDLgmrmTzRb8Y
key:                  Ranged-sets-0.4.0-LxdXSIdHskDLgmrmTzRb8Y
license:              BSD-3-Clause
copyright:            Paul Johnson, 2005, 2006, 2007, 2008, 2019
maintainer:           paul@cogito.org.uk
author:               Paul Johnson
stability:            beta
homepage:             https://github.com/PaulJohnson/Ranged-sets
synopsis:             Ranged sets for Haskell
description:
    A ranged set is an ordered list of ranges.  This allows sets such as all reals x such that:

    > (0.25 < x <= 0.75 or 1.4 <= x < 2.3 or 4.5 < x)

    Alternatively you can have all strings s such that:

    >    ("F" <= s < "G")

category:             Data
abi:                  eeeb6ddd7ab2d19b8275d27e15f4ab22
exposed:              True
exposed-modules:
    Data.Ranged Data.Ranged.Boundaries Data.Ranged.RangedSet
    Data.Ranged.Ranges

import-dirs:          /usr/lib/ghc-9.0.1/site-local/Ranged-sets-0.4.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/Ranged-sets-0.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/Ranged-sets-0.4.0
hs-libraries:         HSRanged-sets-0.4.0-LxdXSIdHskDLgmrmTzRb8Y
depends:
    HUnit-1.6.2.0-2lDDmQCEetY9OrwZ2lDZMS
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn base-4.15.0.0

haddock-interfaces:   /usr/share/doc/haskell-ranged-sets/html/Ranged-sets.haddock
haddock-html:         /usr/share/doc/haskell-ranged-sets/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

