#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 recursion-schemes
version:              5.2.2.1
visibility:           public
id:                   recursion-schemes-5.2.2.1-GIOcr6kiJRwF7IpLuwEglM
key:                  recursion-schemes-5.2.2.1-GIOcr6kiJRwF7IpLuwEglM
license:              BSD-2-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:
    "Samuel Gélineau" <gelisam@gmail.com>,
    "Ryan Scott" <ryan.gl.scott@gmail.com>,
    "Luc Tielen" <luc.tielen@gmail.com>

author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/recursion-schemes/
synopsis:
    Representing common recursion patterns as higher-order functions

description:
    Many recursive functions share the same structure, e.g. pattern-match on the input and, depending on the data constructor, either recur on a smaller input or terminate the recursion with the base case. Another one: start with a seed value, use it to produce the first element of an infinite list, and recur on a modified seed in order to produce the rest of the list. Such a structure is called a recursion scheme. Using higher-order functions to implement those recursion schemes makes your code clearer, faster, and safer. See README for details.

category:             Control, Recursion
abi:                  d99e794ea9b9c83e84089e2d751dc6ff
exposed:              True
exposed-modules:
    Data.Functor.Base Data.Functor.Foldable Data.Functor.Foldable.TH

hidden-modules:       Paths_recursion_schemes
import-dirs:          /usr/lib/ghc-9.0.1/site-local/recursion-schemes-5.2.2.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/recursion-schemes-5.2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/recursion-schemes-5.2.2.1
hs-libraries:         HSrecursion-schemes-5.2.2.1-GIOcr6kiJRwF7IpLuwEglM
depends:
    base-4.15.0.0 base-orphans-0.8.5-9Vy89uWy99J3J2xegcwWvH
    comonad-5.0.8-FQMHC8Di1aZAOXOGXELcFI containers-0.6.4.1
    data-fix-0.3.2-FIAjuUl9RSe337ThPKUScQ
    free-5.1.7-FWBUU8xEKPX4Q9z8pw5z7Z template-haskell-2.17.0.0
    th-abstraction-0.4.3.0-DBpnRpG8EZgFebz88L1kOA transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-recursion-schemes/html/recursion-schemes.haddock

haddock-html:         /usr/share/doc/haskell-recursion-schemes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

