#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 retrie
version:              1.0.0.0
visibility:           public
id:                   retrie-1.0.0.0-2jUAJqPnLThIO2PCSKXyf4
key:                  retrie-1.0.0.0-2jUAJqPnLThIO2PCSKXyf4
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  e3d7a37507ec633595ddcf981ee78368
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.ExactPrint Retrie.ExactPrint.Annotated Retrie.Expr
    Retrie.Fixity Retrie.FreeVars Retrie.GHC Retrie.GroundTerms
    Retrie.Monad Retrie.Options Retrie.PatternMap.Bag
    Retrie.PatternMap.Class Retrie.PatternMap.Instances Retrie.Pretty
    Retrie.Quantifiers Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.0.1/site-local/retrie-1.0.0.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/retrie-1.0.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/retrie-1.0.0.0
hs-libraries:         HSretrie-1.0.0.0-2jUAJqPnLThIO2PCSKXyf4
depends:
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw
    async-2.2.3-IdiNIvUG6Je7aMAPJeWE0D base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF directory-1.3.6.1
    filepath-1.4.2.1 ghc-9.0.1
    ghc-exactprint-0.6.4-9TwOd8WPowIFvEKFh1hUBa mtl-2.2.2
    optparse-applicative-0.16.1.0-2gAu0ltAuRsE34mFhrRUQs
    process-1.6.11.0 random-shuffle-0.0.4-2qOTJTYYC1VKS4UiypqP8H
    syb-0.7.2.1-JG4kH6P0JxMKeIFdjWhhC8 text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

