#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.12
visibility:           public
id:                   scotty-0.12-93SRausvSqU2vnWMduF9zz
key:                  scotty-0.12-93SRausvSqU2vnWMduF9zz
license:              BSD-3-Clause
copyright:            (c) 2012-Present Andrew Farmer
maintainer:           Andrew Farmer <xichekolas@gmail.com>
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    import Data.Monoid (mconcat)

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- param &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  d0fd9bc9015d6f0bd5167e4fe68e2ed0
exposed:              True
exposed-modules:      Web.Scotty Web.Scotty.Internal.Types Web.Scotty.Trans
hidden-modules:       Web.Scotty.Action Web.Scotty.Route Web.Scotty.Util
import-dirs:          /usr/lib/ghc-9.0.1/site-local/scotty-0.12
library-dirs:         /usr/lib/ghc-9.0.1/site-local/scotty-0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/scotty-0.12
hs-libraries:         HSscotty-0.12-93SRausvSqU2vnWMduF9zz
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S base-4.15.0.0
    base-compat-batteries-0.11.2-6L30a7IXCLo3IOkJvEzRQ6
    blaze-builder-0.4.2.2-Iw4q9HoGXXULmCBD2udQGP bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC exceptions-0.10.4
    http-types-0.12.3-5xSWCbzPZMJ3FKkHNvWW2m
    monad-control-1.0.3.1-Endiji3hqqp3N5FxAxM6jw mtl-2.2.2
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    regex-compat-0.95.2.1-AyC0wJj3rmJIrop9pFbSaj text-1.2.4.1
    transformers-0.5.6.2 transformers-base-0.4.6-FnmENEsvcCW4yNlDEn2XlP
    transformers-compat-0.7.1-27E2wCklav6CMkj1Ns7rzE
    wai-3.2.3-5Y0o3GgLhLBDIUVnFhg417
    wai-extra-3.1.7-7O6xxSYSpPwLxUDTZSwbv3
    warp-3.3.18-FG6iRvxgYKDGN1ukLWsD2N

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

