#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2
visibility:           public
id:                   semialign-1.2-IrjoVCSw3GvBof9nsJjstT
key:                  semialign-1.2-IrjoVCSw3GvBof9nsJjstT
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  3f6838b6eb0c4b8b766dd7c2defea4ed
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/semialign-1.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/semialign-1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/semialign-1.2
hs-libraries:         HSsemialign-1.2-IrjoVCSw3GvBof9nsJjstT
depends:
    base-4.15.0.0 containers-0.6.4.1
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    indexed-traversable-instances-0.1-77RbIbVOkYl1vxiP35RFOP
    semigroupoids-5.3.6-8YyLw1xUGcxBRUiDY7goKe
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25
    these-1.1.1.1-deKYvIFkgpB6gZitfRgol transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

