#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 serialise
version:              0.2.3.0
visibility:           public
id:                   serialise-0.2.3.0-1nOR1hyH7skL9bUKd1QrHU
key:                  serialise-0.2.3.0-1nOR1hyH7skL9bUKd1QrHU
license:              BSD-3-Clause
copyright:
    2015-2017 Duncan Coutts,
    2015-2017 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
homepage:             https://github.com/well-typed/cborg
synopsis:             A binary serialisation library for Haskell values.
description:
    This package (formerly @binary-serialise-cbor@) provides pure, efficient
    serialization of Haskell values directly into @ByteString@s for storage or
    transmission purposes. By providing a set of type class instances, you can
    also serialise any custom data type you have as well.

    The underlying binary format used is the '\''Concise Binary Object
    Representation'\'', or CBOR, specified in RFC 7049. As a result,
    serialised Haskell values have implicit structure outside of the
    Haskell program itself, meaning they can be inspected or analyzed
    without custom tools.

    An implementation of the standard bijection between CBOR and JSON is provided
    by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility for
    working with CBOR data.

category:             Codec
abi:                  1374748a4c247958beeba1e68377c34c
exposed:              True
exposed-modules:
    Codec.Serialise Codec.Serialise.Class Codec.Serialise.Decoding
    Codec.Serialise.Encoding Codec.Serialise.IO
    Codec.Serialise.Internal.GeneralisedUTF8 Codec.Serialise.Properties
    Codec.Serialise.Tutorial

import-dirs:          /usr/lib/ghc-9.0.1/site-local/serialise-0.2.3.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/serialise-0.2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/serialise-0.2.3.0
hs-libraries:         HSserialise-0.2.3.0-1nOR1hyH7skL9bUKd1QrHU
depends:
    array-0.5.4.0 base-4.15.0.0 bytestring-0.10.12.1
    cborg-0.2.5.0-G8isyjKSwV9I2ixUk7eYz0 containers-0.6.4.1
    ghc-prim-0.7.0 half-0.3.1-76Ia61sNxf53I73xlsxmdK
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz text-1.2.4.1 time-1.9.3
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/haskell-serialise/html/serialise.haddock
haddock-html:         /usr/share/doc/haskell-serialise/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

