#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 servant-swagger
version:              1.1.10
visibility:           public
id:                   servant-swagger-1.1.10-58E4PmvjukOL8a1h8eHuWN
key:                  servant-swagger-1.1.10-58E4PmvjukOL8a1h8eHuWN
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           nickolay.kudasov@gmail.com
author:               David Johnson, Nickolay Kudasov
homepage:             https://github.com/haskell-servant/servant-swagger
synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  5f3b6baf79413c3a704d1ce8f8dc01a5
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.0.1/site-local/servant-swagger-1.1.10
library-dirs:         /usr/lib/ghc-9.0.1/site-local/servant-swagger-1.1.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/servant-swagger-1.1.10
hs-libraries:         HSservant-swagger-1.1.10-58E4PmvjukOL8a1h8eHuWN
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    aeson-pretty-0.8.9-AXFdNE1ZWy326pjreSMahS base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC bytestring-0.10.12.1
    hspec-2.8.3-KpDDh4qNyBt7FbqE4tn9gO
    http-media-0.8.0.0-7FCvEqaHusr3Wsb2XQBRDO
    insert-ordered-containers-0.2.5-I3JJphhz6As6TxM2MZmhF3
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    servant-0.18.3-Ls4uW1KehaeLa70NK0aF5V
    singleton-bool-0.1.6-HMd8b5o9srcKE3b88hhcU5
    swagger2-2.6.1-EJUaSpsAg0iDwV0H6k8Zjd text-1.2.4.1
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

