#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 skylighting-core
version:              0.11
visibility:           public
id:                   skylighting-core-0.11-7LP3rSY8rMEK9S1qERNvlJ
key:                  skylighting-core-0.11-7LP3rSY8rMEK9S1qERNvlJ
license:              BSD-3-Clause
copyright:            (C) 2016-2018 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             https://github.com/jgm/skylighting
synopsis:             syntax highlighting library
description:
    Skylighting is a syntax highlighting library.
    It derives its tokenizers from XML syntax
    definitions used by KDE'\''s KSyntaxHighlighting
    framework, so any syntax supported by that
    framework can be added. An optional command-line
    program is provided.
    Skylighting is intended to be the successor to
    highlighting-kate.
    This package provides the core highlighting
    functionality under a permissive license. It also
    bundles XML parser definitions licensed under the
    GPL.

category:             Text
abi:                  7aa52e73a20fda72cdb8db5b73206734
exposed:              True
exposed-modules:
    Skylighting.Core Skylighting.Format.ANSI Skylighting.Format.HTML
    Skylighting.Format.LaTeX Skylighting.Loader Skylighting.Parser
    Skylighting.Regex Skylighting.Styles Skylighting.Tokenizer
    Skylighting.Types

hidden-modules:
    Regex.KDE Regex.KDE.Regex Regex.KDE.Compile Regex.KDE.Match

import-dirs:          /usr/lib/ghc-9.0.1/site-local/skylighting-core-0.11
library-dirs:         /usr/lib/ghc-9.0.1/site-local/skylighting-core-0.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/skylighting-core-0.11
hs-libraries:         HSskylighting-core-0.11-7LP3rSY8rMEK9S1qERNvlJ
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    base64-bytestring-1.2.1.0-BH3if0BufO51UJ74fSwj5E binary-0.8.8.0
    blaze-html-0.9.1.2-K4t4PnwLIn1K06QqwerVVe bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR
    colour-2.3.6-A2WfTrEvP6L95Bkq22KRLt containers-0.6.4.1
    directory-1.3.6.1 filepath-1.4.2.1 mtl-2.2.2
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj text-1.2.4.1
    transformers-0.5.6.2 utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    xml-conduit-1.9.1.1-6pgp6KEeQtY9ZzjKhWpcJ6

haddock-interfaces:
    /usr/share/doc/haskell-skylighting-core/html/skylighting-core.haddock

haddock-html:         /usr/share/doc/haskell-skylighting-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

