#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-core
version:              1.0.4.2
visibility:           public
id:                   snap-core-1.0.4.2-6m97YUce1fZLcbTMEmqPer
key:                  snap-core-1.0.4.2-6m97YUce1fZLcbTMEmqPer
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  a99f0215a38e0e39fbc18ef570c0bbfb
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing Snap.Test
    Snap.Types.Headers Snap.Util.CORS Snap.Util.FileServe
    Snap.Util.FileUploads Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileServe Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.0.1/site-local/snap-core-1.0.4.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/snap-core-1.0.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/snap-core-1.0.4.2
hs-libraries:         HSsnap-core-1.0.4.2-6m97YUce1fZLcbTMEmqPer
depends:
    HUnit-1.6.2.0-2lDDmQCEetY9OrwZ2lDZMS
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR containers-0.6.4.1
    directory-1.3.6.1 filepath-1.4.2.1
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    io-streams-1.5.2.1-Jlp45lxqfPx4Fst4vEBBEe
    lifted-base-0.2.3.12-9ycPGhAb6lA2fZITKKqDUU
    monad-control-1.0.3.1-Endiji3hqqp3N5FxAxM6jw mtl-2.2.2
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    old-locale-1.0.0.7-8b6vATcbl2rGNT5WzdAV1N
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR
    readable-0.3.1-Afw7RWAgDtZHzFfKPC3wpg
    regex-posix-0.96.0.1-ICff79JbeoKL4XN6EAg8yK text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 transformers-base-0.4.6-FnmENEsvcCW4yNlDEn2XlP
    unix-compat-0.5.3-CsWJk3UHZrh7lbWn5tdOhn
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

