#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-server
version:              1.1.2.0
visibility:           public
id:                   snap-server-1.1.2.0-84sYeXFIJdYKvaCFtyKVWk
key:                  snap-server-1.1.2.0-84sYeXFIJdYKvaCFtyKVWk
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors  (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             A web server for the Snap Framework
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    The Snap HTTP server is a high performance web server library written in
    Haskell. Together with the @snap-core@ library upon which it depends, it
    provides a clean and efficient Haskell programming interface to the HTTP
    protocol.

category:             Web, Snap, IO-Streams
abi:                  3063b6943737f473517e73256111c1b4
exposed:              True
exposed-modules:
    Snap.Http.Server Snap.Http.Server.Config Snap.Http.Server.Types
    Snap.Internal.Http.Server.Config Snap.Internal.Http.Server.Types
    System.FastLogger

hidden-modules:
    Paths_snap_server Control.Concurrent.Extended
    Snap.Internal.Http.Server.Address Snap.Internal.Http.Server.Clock
    Snap.Internal.Http.Server.Common Snap.Internal.Http.Server.Date
    Snap.Internal.Http.Server.Parser Snap.Internal.Http.Server.Session
    Snap.Internal.Http.Server.Socket Snap.Internal.Http.Server.Thread
    Snap.Internal.Http.Server.TimeoutManager
    Snap.Internal.Http.Server.TLS System.SendFile System.SendFile.Linux

import-dirs:          /usr/lib/ghc-9.0.1/site-local/snap-server-1.1.2.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/snap-server-1.1.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/snap-server-1.1.2.0
hs-libraries:         HSsnap-server-1.1.2.0-84sYeXFIJdYKvaCFtyKVWk
depends:
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    blaze-builder-0.4.2.2-Iw4q9HoGXXULmCBD2udQGP bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR
    clock-0.8.2-15wgDho9V998irPBw0mafD containers-0.6.4.1
    filepath-1.4.2.1 io-streams-1.5.2.1-Jlp45lxqfPx4Fst4vEBBEe
    io-streams-haproxy-1.0.1.0-ENUzk8Iz4yaIJmlYTDTZ7E
    lifted-base-0.2.3.12-9ycPGhAb6lA2fZITKKqDUU mtl-2.2.2
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    old-locale-1.0.0.7-8b6vATcbl2rGNT5WzdAV1N
    snap-core-1.0.4.2-6m97YUce1fZLcbTMEmqPer text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.5.3-CsWJk3UHZrh7lbWn5tdOhn
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/haskell-snap-server/html/snap-server.haddock
haddock-html:         /usr/share/doc/haskell-snap-server/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

