#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 sorted-list
version:              0.2.1.0
visibility:           public
id:                   sorted-list-0.2.1.0-GAuY2s8imm748N24vRN1OU
key:                  sorted-list-0.2.1.0-GAuY2s8imm748N24vRN1OU
license:              BSD-3-Clause
maintainer:           dhelta.diaz@gmail.com
author:               Daniel Díaz
homepage:
    https://github.com/Daniel-Diaz/sorted-list/blob/master/README.md

synopsis:             Type-enforced sorted lists and related functions.
description:
    Type-enforced sorted lists and related functions.

    These are useful for:

    * Constraining the argument of a function to be a sorted list
    by stating in your type that the input list is a sorted list.

    * Avoiding sorting a list twice.

    * Creating a list that is sorted from the moment of its construction,
    so it doesn'\''t have to be sorted later.

    * Performing list operations keeping the input list sorted.

    * Improving those list operations that can be
    benefited from the ordering of its elements.

    * Creating infinite lists that are sorted!

    * And more!

    If you are missing a feature, do not hesitate
    to ask by opening an issue at the bug-tracker.

category:             Data
abi:                  1f0bbcee1bceb433742761397121f288
exposed:              True
exposed-modules:      Data.SortedList
import-dirs:          /usr/lib/ghc-9.0.1/site-local/sorted-list-0.2.1.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/sorted-list-0.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/sorted-list-0.2.1.0
hs-libraries:         HSsorted-list-0.2.1.0-GAuY2s8imm748N24vRN1OU
depends:              base-4.15.0.0 deepseq-1.4.5.0
haddock-interfaces:   /usr/share/doc/haskell-sorted-list/html/sorted-list.haddock
haddock-html:         /usr/share/doc/haskell-sorted-list/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

