#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tabular
version:              0.2.2.8
visibility:           public
id:                   tabular-0.2.2.8-8JF65zbpqg3J2xw1bK6aDa
key:                  tabular-0.2.2.8-8JF65zbpqg3J2xw1bK6aDa
license:              BSD-3-Clause
maintainer:           Ben Gamari <bgamari@well-typed.com>
author:               Eric Kow
homepage:             https://github.com/bgamari/tabular
synopsis:             Two-dimensional data tables with rendering functions
description:
    Tabular provides a Haskell representation of two-dimensional
    data tables, the kind that you might find in a spreadsheet or
    or a research report.  It also comes with some default
    rendering functions for turning those tables into ASCII art,
    simple text with an arbitrary delimiter, CSV, HTML or LaTeX.

    Below is an example of the kind of output this library produces.
    The tabular package can group rows and columns, each group
    having one of three separators (no line, single line, double line)
    between its members.

    >     || memtest 1 | memtest 2 ||  time test  | time test 2
    > ====++===========+===========++=============+============
    > A 1 ||       hog |  terrible ||        slow |      slower
    > A 2 ||       pig |   not bad ||        fast |     slowest
    > ----++-----------+-----------++-------------+------------
    > B 1 ||      good |     awful || intolerable |    bearable
    > B 2 ||    better | no chance ||    crawling |     amazing
    > B 3 ||       meh |   well... ||  worst ever |          ok

category:             Text
abi:                  734c5b00a9b8e71f229ba97bb30fbc79
exposed:              True
exposed-modules:
    Text.Tabular Text.Tabular.AsciiArt Text.Tabular.Csv
    Text.Tabular.Html Text.Tabular.Latex Text.Tabular.SimpleText

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tabular-0.2.2.8
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tabular-0.2.2.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tabular-0.2.2.8
hs-libraries:         HStabular-0.2.2.8-8JF65zbpqg3J2xw1bK6aDa
depends:
    base-4.15.0.0 csv-0.1.2-GpI2QllglKGGY6a3bGhdjA
    html-1.0.1.2-Bsh4OTsmkJP16P65gnPRzx mtl-2.2.2

haddock-interfaces:   /usr/share/doc/haskell-tabular/html/tabular.haddock
haddock-html:         /usr/share/doc/haskell-tabular/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

