#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-utils
version:              1.6.1
visibility:           public
id:                   tamarin-prover-utils-1.6.1-3c8nRCQm77V8XdZooq6PQy
key:                  tamarin-prover-utils-1.6.1-3c8nRCQm77V8XdZooq6PQy
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  cb2adb2b6a0ee3db6af7e7170143cc71
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.Ignore Extension.Data.ByteString Extension.Data.Label
    Extension.Data.Monoid Extension.Prelude Logic.Connectives
    System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tamarin-prover-utils-1.6.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tamarin-prover-utils-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/tamarin-prover-utils-1.6.1

hs-libraries:         HStamarin-prover-utils-1.6.1-3c8nRCQm77V8XdZooq6PQy
depends:
    SHA-1.6.4.4-7e0sYz0lBWb1CdwjpynTkG base-4.15.0.0
    base64-bytestring-1.2.1.0-BH3if0BufO51UJ74fSwj5E binary-0.8.8.0
    blaze-builder-0.4.2.2-Iw4q9HoGXXULmCBD2udQGP bytestring-0.10.12.1
    containers-0.6.4.1 deepseq-1.4.5.0 dlist-1.0-UyN3fdgb0F8e8xXMrElbD
    exceptions-0.10.4 fclabels-2.0.5.1-KLXTPFBZLlnIuxiQ67NnDH mtl-2.2.2
    pretty-1.1.3.6 safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    syb-0.7.2.1-JG4kH6P0JxMKeIFdjWhhC8 time-1.9.3 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

