#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-short
version:              0.1.4
visibility:           public
id:                   text-short-0.1.4-FOhkAXI3iYvEwvBO16tzUF
key:                  text-short-0.1.4-FOhkAXI3iYvEwvBO16tzUF
license:              BSD-3-Clause
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
synopsis:             Memory-efficient representation of Unicode text strings
description:
    This package provides the '\''ShortText'\'' type which is suitable for keeping many short strings in memory. This is similiar to how '\''ShortByteString'\'' relates to '\''ByteString'\''.

    The main difference between '\''Text'\'' and '\''ShortText'\'' is that '\''ShortText'\'' uses UTF-8 instead of UTF-16 internally and also doesn'\''t support zero-copy slicing (thereby saving 2 words). Consequently, the memory footprint of a (boxed) '\''ShortText'\'' value is 4 words (2 words when unboxed) plus the length of the UTF-8 encoded payload.

category:             Data
abi:                  1a4fbc2fac0e782fde9c44881747a600
exposed:              True
exposed-modules:
    Data.Text.Short Data.Text.Short.Partial Data.Text.Short.Unsafe

hidden-modules:       Data.Text.Short.Internal PrimOps
import-dirs:          /usr/lib/ghc-9.0.1/site-local/text-short-0.1.4
library-dirs:         /usr/lib/ghc-9.0.1/site-local/text-short-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/text-short-0.1.4
hs-libraries:         HStext-short-0.1.4-FOhkAXI3iYvEwvBO16tzUF
depends:
    base-4.15.0.0 binary-0.8.8.0 bytestring-0.10.12.1 deepseq-1.4.5.0
    ghc-prim-0.7.0 hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    template-haskell-2.17.0.0 text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-text-short/html/text-short.haddock
haddock-html:         /usr/share/doc/haskell-text-short/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

