#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tf-random
version:              0.5
visibility:           public
id:                   tf-random-0.5-F4t9QI0KExIJc6ILEY8DVo
key:                  tf-random-0.5-F4t9QI0KExIJc6ILEY8DVo
license:              BSD-3-Clause
maintainer:           Michał Pałka <michal.palka@chalmers.se>
author:               Michał Pałka <michal.palka@chalmers.se>
synopsis:             High-quality splittable pseudorandom number generator
description:
    This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.

    The package provides the following:

    * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.

    * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.

    * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.

    * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.

    The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.

    Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.

category:             Random
abi:                  8185e5df4531bcfd8ba59d753db47a1c
exposed:              True
exposed-modules:
    System.Random.TF System.Random.TF.Gen System.Random.TF.Init
    System.Random.TF.Instances

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tf-random-0.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tf-random-0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tf-random-0.5
hs-libraries:         HStf-random-0.5-F4t9QI0KExIJc6ILEY8DVo
depends:
    base-4.15.0.0 primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR time-1.9.3

haddock-interfaces:   /usr/share/doc/haskell-tf-random/html/tf-random.haddock
haddock-html:         /usr/share/doc/haskell-tf-random/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

