#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tidal
version:              1.7.8
visibility:           public
id:                   tidal-1.7.8-CWrgQGhcCDM9MbTMTyvWaS
key:                  tidal-1.7.8-CWrgQGhcCDM9MbTMTyvWaS
license:              GPL-3.0-only
copyright:            (c) Alex McLean and other contributors, 2021
maintainer:
    Alex McLean <alex@slab.org>, Mike Hodnick <mike.hodnick@gmail.com>

author:               Alex McLean
stability:            Experimental
homepage:             http://tidalcycles.org/
synopsis:             Pattern language for improvised music
description:
    Tidal is a domain specific language for live coding patterns.

category:             Sound
abi:                  2bf7483a43c85f8c189a3c4f8c8ff402
exposed:              True
exposed-modules:
    Paths_tidal Sound.Tidal.Bjorklund Sound.Tidal.Carabiner
    Sound.Tidal.Chords Sound.Tidal.Config Sound.Tidal.Context
    Sound.Tidal.Control Sound.Tidal.Core Sound.Tidal.EspGrid
    Sound.Tidal.Params Sound.Tidal.ParseBP Sound.Tidal.Pattern
    Sound.Tidal.Scales Sound.Tidal.Show Sound.Tidal.Simple
    Sound.Tidal.Stream Sound.Tidal.Tempo Sound.Tidal.Time
    Sound.Tidal.Transition Sound.Tidal.UI Sound.Tidal.Utils
    Sound.Tidal.Version

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tidal-1.7.8
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tidal-1.7.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tidal-1.7.8
hs-libraries:         HStidal-1.7.8-CWrgQGhcCDM9MbTMTyvWaS
depends:
    base-4.15.0.0 bifunctors-5.5.11-3MgHowlkzBNDa84Pzdaw4w
    bytestring-0.10.12.1 clock-0.8.2-15wgDho9V998irPBw0mafD
    colour-2.3.6-A2WfTrEvP6L95Bkq22KRLt containers-0.6.4.1
    deepseq-1.4.5.0 hosc-0.19.1-F6X6ccssqQzJKbWpDBZUUi
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili parsec-3.1.14.0
    primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR text-1.2.4.1
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-tidal/html/tidal.haddock
haddock-html:         /usr/share/doc/haskell-tidal/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

