#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 timezone-olson
version:              0.2.0
visibility:           public
id:                   timezone-olson-0.2.0-AoWMH3XDF8eIKokakRudJH
key:                  timezone-olson-0.2.0-AoWMH3XDF8eIKokakRudJH
license:              BSD-3-Clause
copyright:            Copyright (c) 2010-2018 Yitzchak Gale. All rights reserved.
maintainer:           yitz@sefer.org
author:               Yitzchak Gale
homepage:             http://projects.haskell.org/time-ng/
synopsis:
    A pure Haskell parser and renderer for binary Olson timezone files

description:
    A parser and renderer for binary Olson timezone
    files whose format is specified by the tzfile(5)
    man page on Unix-like systems. For more
    information about this format, see
    <http://www.iana.org/time-zones/repository/tz-link.html>.
    Functions are provided for converting the parsed data into
    '\''TimeZoneSeries'\'' objects from the timezone-series
    package. On many platforms, binary Olson timezone
    files suitable for use with this package are
    available in the directory /usr/share/zoneinfo
    and its subdirectories on your computer.
    For a way to read binary Olson timezone files at compile
    time, see the timezone-olson-th package
    (<http://hackage.haskell.org/package/timezone-olson-th>).

category:             Data
abi:                  1e8607c15224fb1222f025ce97a4a447
exposed:              True
exposed-modules:
    Data.Time.LocalTime.TimeZone.Olson
    Data.Time.LocalTime.TimeZone.Olson.Parse
    Data.Time.LocalTime.TimeZone.Olson.Render
    Data.Time.LocalTime.TimeZone.Olson.Types

import-dirs:          /usr/lib/ghc-9.0.1/site-local/timezone-olson-0.2.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/timezone-olson-0.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/timezone-olson-0.2.0
hs-libraries:         HStimezone-olson-0.2.0-AoWMH3XDF8eIKokakRudJH
depends:
    base-4.15.0.0 binary-0.8.8.0 bytestring-0.10.12.1
    extensible-exceptions-0.1.1.4-78NMIT9qofYFWl0e48Yw92 time-1.9.3
    timezone-series-0.1.9-BOaWIUAL0b77nThbCcBvws

haddock-interfaces:
    /usr/share/doc/haskell-timezone-olson/html/timezone-olson.haddock

haddock-html:         /usr/share/doc/haskell-timezone-olson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

