#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tomland
version:              1.3.3.0
visibility:           public
id:                   tomland-1.3.3.0-5sS4M9CA7pAA632YVj8SB1
key:                  tomland-1.3.3.0-5sS4M9CA7pAA632YVj8SB1
license:              MPL-2.0
copyright:            2018-2021 Kowainik
maintainer:           Kowainik <xrom.xkov@gmail.com>
author:               Dmitrii Kovanikov, Veronika Romashkina
homepage:             https://github.com/kowainik/tomland
synopsis:             Bidirectional TOML serialization
description:
    Implementation of bidirectional TOML serialization. Simple codecs look like this:

    @
    __data__ User = User
    \    { userName :: Text
    \    , userAge  :: Int
    \    }
    \
    \userCodec :: TomlCodec User
    \userCodec = User
    \    \<$\> Toml.text "name" .= userName
    \    \<*\> Toml.int  "age"  .= userAge
    @

    The following blog post has more details about library design:

    * [tomland: Bidirectional TOML serialization](https://kowainik.github.io/posts/2019-01-14-tomland)

category:             TOML, Text, Configuration
abi:                  b9d21197c66ce144066c46a7806c140c
exposed:              True
exposed-modules:
    Toml Toml.Codec Toml.Codec.BiMap Toml.Codec.BiMap.Conversion
    Toml.Codec.Code Toml.Codec.Combinator Toml.Codec.Combinator.Common
    Toml.Codec.Combinator.Custom Toml.Codec.Combinator.List
    Toml.Codec.Combinator.Map Toml.Codec.Combinator.Monoid
    Toml.Codec.Combinator.Primitive Toml.Codec.Combinator.Set
    Toml.Codec.Combinator.Table Toml.Codec.Combinator.Time
    Toml.Codec.Combinator.Tuple Toml.Codec.Di Toml.Codec.Error
    Toml.Codec.Generic Toml.Codec.Types Toml.Parser Toml.Parser.Core
    Toml.Parser.Item Toml.Parser.Key Toml.Parser.String
    Toml.Parser.Validate Toml.Parser.Value Toml.Type Toml.Type.AnyValue
    Toml.Type.Edsl Toml.Type.Key Toml.Type.PrefixTree Toml.Type.Printer
    Toml.Type.TOML Toml.Type.UValue Toml.Type.Value

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tomland-1.3.3.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tomland-1.3.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tomland-1.3.3.0
hs-libraries:         HStomland-1.3.3.0-5sS4M9CA7pAA632YVj8SB1
depends:
    base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    megaparsec-9.2.0-4jOz50swwTdC1OkC7cXk5Y mtl-2.2.2
    parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    validation-selective-0.1.0.1-KsgzMx6RUrN38Bo4vmefkW

haddock-interfaces:   /usr/share/doc/haskell-tomland/html/tomland.haddock
haddock-html:         /usr/share/doc/haskell-tomland/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

