#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.1
visibility:           public
id:                   trifecta-2.1.1-J5FWuOR1IcuCeBtaItH8Mh
key:                  trifecta-2.1.1-J5FWuOR1IcuCeBtaItH8Mh
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f44fe474630e40dd4c32a85a84ee6d0a
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.0.1/site-local/trifecta-2.1.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/trifecta-2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/trifecta-2.1.1
hs-libraries:         HStrifecta-2.1.1-J5FWuOR1IcuCeBtaItH8Mh
depends:
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw array-0.5.4.0
    base-4.15.0.0 blaze-builder-0.4.2.2-Iw4q9HoGXXULmCBD2udQGP
    blaze-html-0.9.1.2-K4t4PnwLIn1K06QqwerVVe
    blaze-markup-0.8.2.8-16j1paqjrAu4vBleBUkWjQ bytestring-0.10.12.1
    charset-0.3.9-F3XIOnirqkiIgq7OIkQoyd
    comonad-5.0.8-FQMHC8Di1aZAOXOGXELcFI containers-0.6.4.1
    deepseq-1.4.5.0 fingertree-0.1.4.2-8i1KYSgif9U7xqcuLyHbU1
    ghc-prim-0.7.0 hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO mtl-2.2.2
    parsers-0.12.10-Fygk0UygGWIJGasEEw3Ph0
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n
    prettyprinter-ansi-terminal-1.1.3-VoiK4SrFFn3Kv8sAYtuCw
    profunctors-5.6.2-BCER5gcx0SlDcSUAEwXMiO
    reducers-3.12.4-70B69vnhYAA2xLBEck6pAs transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

