#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 unagi-chan
version:              0.4.1.3
visibility:           public
id:                   unagi-chan-0.4.1.3-3n1jqpSRBzXFKCI2dW461V
key:                  unagi-chan-0.4.1.3-3n1jqpSRBzXFKCI2dW461V
license:              BSD-3-Clause
maintainer:           brandon.m.simmons@gmail.com
author:               Brandon Simmons
synopsis:             Fast concurrent queues with a Chan-like API, and more
description:
    This library provides implementations of concurrent FIFO queues (for both
    general boxed and primitive unboxed values) that are fast, perform well
    under contention, and offer a Chan-like interface. The library may be of
    limited usefulness outside of x86 architectures where the fetch-and-add
    instruction is not available.

    We export several variations of our design; some support additional
    functionality while others try for lower latency by removing features or
    making them more restrictive (e.g. in the @Unboxed@ variants).

    - @Unagi@: a general-purpose near drop-in replacement for @Chan@.

    - @Unagi.Unboxed@: like @Unagi@ but specialized for primitive types; this
    may perform better if a queue grows very large.

    - @Unagi.Bounded@: a bounded variant with blocking and non-blocking writes,
    and other functionality where a notion of the queue'\''s capacity is
    required.

    - @Unagi.NoBlocking@: lowest latency implementations for when blocking
    reads aren'\''t required.

    - @Unagi.NoBlocking.Unboxed@: like @Unagi.NoBlocking@ but for primitive
    types.

    Some of these may be deprecated in the future if they are found to provide
    little performance benefit, or no unique features; you should benchmark and
    experiment with them for your use cases, and please submit pull requests
    for additions to the benchmark suite that reflect what you find.

    Here is an example benchmark measuring the time taken to concurrently write
    and read 100,000 messages, with work divided amongst increasing number of
    readers and writers, comparing against the top-performing queues in the
    standard libraries. The inset graph shows a zoomed-in view on the
    implementations here.

    <<http://i.imgur.com/J5rLUFn.png>>

category:             Concurrency
abi:                  725272e260143ecd1709b5e727116097
exposed:              True
exposed-modules:
    Control.Concurrent.Chan.Unagi Control.Concurrent.Chan.Unagi.Bounded
    Control.Concurrent.Chan.Unagi.NoBlocking
    Control.Concurrent.Chan.Unagi.NoBlocking.Unboxed
    Control.Concurrent.Chan.Unagi.Unboxed

hidden-modules:
    Control.Concurrent.Chan.Unagi.Internal
    Control.Concurrent.Chan.Unagi.Unboxed.Internal
    Control.Concurrent.Chan.Unagi.Bounded.Internal
    Control.Concurrent.Chan.Unagi.NoBlocking.Internal
    Control.Concurrent.Chan.Unagi.NoBlocking.Types
    Control.Concurrent.Chan.Unagi.NoBlocking.Unboxed.Internal
    Control.Concurrent.Chan.Unagi.Constants Utilities
    Data.Atomics.Counter.Fat

import-dirs:          /usr/lib/ghc-9.0.1/site-local/unagi-chan-0.4.1.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/unagi-chan-0.4.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/unagi-chan-0.4.1.3
hs-libraries:         HSunagi-chan-0.4.1.3-3n1jqpSRBzXFKCI2dW461V
depends:
    atomic-primops-0.8.4-EcdGz35CbdQDJpuPKP2d6p base-4.15.0.0
    ghc-prim-0.7.0 primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz

haddock-interfaces:   /usr/share/doc/haskell-unagi-chan/html/unagi-chan.haddock
haddock-html:         /usr/share/doc/haskell-unagi-chan/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

