#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 unicode-collation
version:              0.1.3.1
visibility:           public
id:                   unicode-collation-0.1.3.1-9fRd98Rhasc7TwBkLBCN3Q
key:                  unicode-collation-0.1.3.1-9fRd98Rhasc7TwBkLBCN3Q
license:              BSD-2-Clause
copyright:            2021 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane
homepage:             https://github.com/jgm/unicode-collation
synopsis:             Haskell implementation of the Unicode Collation Algorithm
description:
    This library provides a pure Haskell implementation of
    the Unicode Collation Algorithm described at
    <http://www.unicode.org/reports/tr10/>.  It is not
    as fully-featured or as performant as @text-icu@, but
    it avoids a dependency on a large C library.
    Locale-specific tailorings are also provided.

category:             Text
abi:                  ef4a8dbb512e7f784ce68d1fc7921799
exposed:              True
exposed-modules:      Text.Collate Text.Collate.Lang Text.Collate.Normalize
hidden-modules:
    Text.Collate.Trie Text.Collate.Collation Text.Collate.Collator
    Text.Collate.CanonicalCombiningClass Text.Collate.TH
    Text.Collate.Tailorings Text.Collate.UnicodeData

import-dirs:          /usr/lib/ghc-9.0.1/site-local/unicode-collation-0.1.3.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/unicode-collation-0.1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/unicode-collation-0.1.3.1
hs-libraries:         HSunicode-collation-0.1.3.1-9fRd98Rhasc7TwBkLBCN3Q
depends:
    base-4.15.0.0 binary-0.8.8.0 bytestring-0.10.12.1
    containers-0.6.4.1 parsec-3.1.14.0 template-haskell-2.17.0.0
    text-1.2.4.1 th-lift-instances-0.1.18-277cz1WljFxFFoGMSqzssz

haddock-interfaces:
    /usr/share/doc/haskell-unicode-collation/html/unicode-collation.haddock

haddock-html:         /usr/share/doc/haskell-unicode-collation/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

