#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 uuid
version:              1.3.15
visibility:           public
id:                   uuid-1.3.15-KvcbvB71W377mxUBX2XOE7
key:                  uuid-1.3.15-KvcbvB71W377mxUBX2XOE7
license:              BSD-3-Clause
copyright:            (c) 2008-2014 Antoine Latter
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:
    For creating, comparing, parsing and printing Universally Unique Identifiers

description:
    This library is useful for creating, comparing, parsing and
    printing Universally Unique Identifiers.

    See <http://en.wikipedia.org/wiki/UUID> for the general idea.

category:             Data
abi:                  64abcf73367ee3b4d657eea0bdbd5820
exposed:              True
exposed-modules:
    Data.UUID Data.UUID.Util Data.UUID.V1 Data.UUID.V3 Data.UUID.V4
    Data.UUID.V5

hidden-modules:       Data.UUID.Named Data.Word.Util
import-dirs:          /usr/lib/ghc-9.0.1/site-local/uuid-1.3.15
library-dirs:         /usr/lib/ghc-9.0.1/site-local/uuid-1.3.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/uuid-1.3.15
hs-libraries:         HSuuid-1.3.15-KvcbvB71W377mxUBX2XOE7
depends:
    base-4.15.0.0 binary-0.8.8.0 bytestring-0.10.12.1
    cryptohash-md5-0.11.101.0-CNxzxy7l7oe2wFcjgOKBFy
    cryptohash-sha1-0.11.100.1-76A50UqL08yHXaRzujd3cE
    entropy-0.4.1.7-66OkMQHXKESGwpio7bQXje
    network-info-0.2.0.10-HRUWFIvhsIZ1Lv1pmqWRl0
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR text-1.2.4.1 time-1.9.3
    uuid-types-1.0.5-9N00rVcWF8YLV2BbcRzeDM

haddock-interfaces:   /usr/share/doc/haskell-uuid/html/uuid.haddock
haddock-html:         /usr/share/doc/haskell-uuid/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

