#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.7
visibility:           public
id:                   wai-extra-3.1.7-7O6xxSYSpPwLxUDTZSwbv3
key:                  wai-extra-3.1.7-7O6xxSYSpPwLxUDTZSwbv3
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  b9a8b79e118e49b910fb19b8ceb53885
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.Jsonp Network.Wai.Middleware.Local
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.Vhost Network.Wai.Parse Network.Wai.Request
    Network.Wai.Test Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:       Network.Wai.Middleware.RequestLogger.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/wai-extra-3.1.7
library-dirs:         /usr/lib/ghc-9.0.1/site-local/wai-extra-3.1.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/wai-extra-3.1.7
hs-libraries:         HSwai-extra-3.1.7-7O6xxSYSpPwLxUDTZSwbv3
depends:
    HUnit-1.6.2.0-2lDDmQCEetY9OrwZ2lDZMS
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw base-4.15.0.0
    base64-bytestring-1.2.1.0-BH3if0BufO51UJ74fSwj5E
    bytestring-0.10.12.1 call-stack-0.4.0-8Okwb0cowpe8mB1pBLnCB
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR containers-0.6.4.1
    cookie-0.4.5-KsNYn2KTPEnIdTHNDYXGny
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC directory-1.3.6.1
    fast-logger-3.0.5-5U7Yc1ziI2k64PjTJWcPvL
    http-types-0.12.3-5xSWCbzPZMJ3FKkHNvWW2m
    http2-3.0.2-LZKiS78hBEO3em0VouAQYX
    iproute-1.7.11-DLPiKG7ZPhYAdkg8ccQ3w3
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    resourcet-1.2.4.3-DSdH8WNuZw9AkjYvTicAaV
    streaming-commons-0.2.2.1-J0b2xLnjHOmKRGcD092H6U text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    vault-0.3.1.5-5rFIghOpfR0F7oBrhbzq8P
    wai-3.2.3-5Y0o3GgLhLBDIUVnFhg417
    wai-logger-2.3.6-69MmnhLjdcACWrxL6PTX4o
    word8-0.1.3-6en08JYOoMR9XQOtl02Wug

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

