#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 what4
version:              1.2.1
visibility:           public
id:                   what4-1.2.1-9w3lw5hwDKb4dnozLhwiLc
key:                  what4-1.2.1-9w3lw5hwDKb4dnozLhwiLc
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2021
maintainer:           jhendrix@galois.com, rdockins@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  487483c123fa3714eae9e7eae39e4d0b
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.DReal
    What4.Solver.ExternalABC What4.Solver.STP What4.Solver.Yices
    What4.Solver.Z3 What4.Symbol What4.Utils.AbstractDomains
    What4.Utils.AnnotatedMap What4.Utils.Arithmetic
    What4.Utils.BVDomain What4.Utils.BVDomain.Arith
    What4.Utils.BVDomain.Bitwise What4.Utils.BVDomain.XOR
    What4.Utils.Complex What4.Utils.Endian What4.Utils.Environment
    What4.Utils.FloatHelpers What4.Utils.HandleReader
    What4.Utils.IncrHash What4.Utils.LeqMap What4.Utils.MonadST
    What4.Utils.OnlyIntRepr What4.Utils.Process What4.Utils.Streams
    What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.0.1/site-local/what4-1.2.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/what4-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/what4-1.2.1
hs-libraries:         HSwhat4-1.2.1-9w3lw5hwDKb4dnozLhwiLc
depends:
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    bifunctors-5.5.11-3MgHowlkzBNDa84Pzdaw4w
    bimap-0.4.0-8gFfljp8erKDJKiTEERr7H
    bv-sized-1.0.3-mdgzyLqerK67ySLFLB6FQ bytestring-0.10.12.1
    config-value-0.8.1-KeLFOkD4SXx3zqrwutdHEH containers-0.6.4.1
    data-binary-ieee754-0.4.4-1uzt85nFoxu5Mgq2DE5oph deepseq-1.4.5.0
    deriving-compat-0.6-Ln8CLuicLPYDlxHzS2qXZO directory-1.3.6.1
    exceptions-0.10.4 extra-1.7.10-32H3SA4Yf8dI1sU3NgBQjm
    filepath-1.4.2.1 fingertree-0.1.4.2-8i1KYSgif9U7xqcuLyHbU1
    ghc-prim-0.7.0 hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    hashtables-1.2.4.2-2wx0ECGqrKH3pmFhYFL0rB
    io-streams-1.5.2.1-Jlp45lxqfPx4Fst4vEBBEe
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    libBF-0.6.2-LJDf5vFwWAtJCbxEvKKPp0 mtl-2.2.2
    panic-0.4.0.1-6ICRVlNw1Qd50vb6RGATyn
    parameterized-utils-2.1.3.0-1wWFRcGMZ6I4PStlYIgLWt
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n process-1.6.11.0
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV template-haskell-2.17.0.0
    temporary-1.3-1fpZ6Xm8biD79YIGypkFzm text-1.2.4.1
    th-abstraction-0.4.3.0-DBpnRpG8EZgFebz88L1kOA
    th-lift-0.8.2-F0VVOrB5SZgFNS1AEtieR9
    th-lift-instances-0.1.18-277cz1WljFxFFoGMSqzssz
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3
    versions-5.0.0-FwmxqoXAgWfh03yZLEZwt
    zenc-0.1.2-QJtmeGzQnrLVIWUj6meUh

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

