#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 x509
version:              1.7.5
visibility:           public
id:                   x509-1.7.5-KZBg6E9cDNpzkDdONM3tO
key:                  x509-1.7.5-KZBg6E9cDNpzkDdONM3tO
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             http://github.com/vincenthz/hs-certificate
synopsis:             X509 reader and writer
description:          X509 reader and writer. please see README
category:             Data
abi:                  8ce641c4a6fdb5891697ec9ec6cfcd9c
exposed:              True
exposed-modules:      Data.X509 Data.X509.EC
hidden-modules:
    Data.X509.Internal Data.X509.CertificateChain
    Data.X509.AlgorithmIdentifier Data.X509.DistinguishedName
    Data.X509.Cert Data.X509.PublicKey Data.X509.PrivateKey
    Data.X509.Ext Data.X509.ExtensionRaw Data.X509.CRL Data.X509.OID
    Data.X509.Signed

import-dirs:          /usr/lib/ghc-9.0.1/site-local/x509-1.7.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/x509-1.7.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/x509-1.7.5
hs-libraries:         HSx509-1.7.5-KZBg6E9cDNpzkDdONM3tO
depends:
    asn1-encoding-0.9.6-1hiEaDzNnvZCKkl9Gb4izO
    asn1-parse-0.9.5-IyxFxvAJU9UHxbgoGf5K5N
    asn1-types-0.3.4-KHBfkOvXvyLC7EfnO8fkLD base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    cryptonite-0.29-19SjDRwWNox27CMfesQpq4
    hourglass-0.2.12-3rdEguFqYyMGZvL0UmpBhl
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr mtl-2.2.2
    pem-0.2.4-KLN0tuS3ZoG84EBMFRxUqE

haddock-interfaces:   /usr/share/doc/haskell-x509/html/x509.haddock
haddock-html:         /usr/share/doc/haskell-x509/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

