"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const passport = require("passport");
const passport_saml_1 = require("./passport-saml");
function findByEmail(email, cb) {
    cb(null);
}
passport.use(new passport_saml_1.Strategy({
    path: "/login/callback",
    entryPoint: "https://openidp.feide.no/simplesaml/saml2/idp/SSOService.php",
    issuer: "passport-saml",
}, function (profile, done) {
    if (profile != null && typeof profile.email === "string") {
        findByEmail(profile.email, function (err, user) {
            if (err) {
                return done(err);
            }
            return done(null, user);
        });
    }
}));
//# sourceMappingURL=test.js.map