#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger
version:              1.22.2
visibility:           public
id:                   hledger-1.22.2-HH3LAkhAuZ320qR1mBUBz5
key:                  hledger-1.22.2-HH3LAkhAuZ320qR1mBUBz5
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  bf3d2706001604e414cbc4efe6e5ca54
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Check.Ordereddates
    Hledger.Cli.Commands.Check.Uniqueleafnames
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Descriptions
    Hledger.Cli.Commands.Diff Hledger.Cli.Commands.Files
    Hledger.Cli.Commands.Help Hledger.Cli.Commands.Import
    Hledger.Cli.Commands.Incomestatement Hledger.Cli.Commands.Notes
    Hledger.Cli.Commands.Payees Hledger.Cli.Commands.Prices
    Hledger.Cli.Commands.Print Hledger.Cli.Commands.Printunique
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Registermatch
    Hledger.Cli.Commands.Rewrite Hledger.Cli.Commands.Roi
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.DocFiles
    Hledger.Cli.Main Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.0.1/site-local/hledger-1.22.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hledger-1.22.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.22.2-HH3LAkhAuZ320qR1mBUBz5
depends:
    Decimal-0.5.2-C6RtKO4JEZBCq6iLATrwho
    Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw base-4.15.0.0
    base-compat-batteries-0.11.2-6L30a7IXCLo3IOkJvEzRQ6
    bytestring-0.10.12.1 cmdargs-0.10.21-9JSptK8vQ5KGyQ5LWB6hlS
    containers-0.6.4.1 data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF
    directory-1.3.6.1 extra-1.7.10-32H3SA4Yf8dI1sU3NgBQjm
    filepath-1.4.2.1 githash-0.1.6.2-7DRZJKfoiuNCoempebAJU2
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH haskeline-0.8.1.0
    hledger-lib-1.22.2-6jY4ZpE9OekqSXdufIhjB
    lucid-2.9.12.1-ElUJ01wTTH05DhClcgeKdU
    math-functions-0.3.4.2-8RHSk1eqU723SpmLsgg43K
    megaparsec-9.2.0-4jOz50swwTdC1OkC7cXk5Y mtl-2.2.2
    old-time-1.1.0.3-K1bOYVfsfw9D9troqm7gA3 process-1.6.11.0
    regex-tdfa-1.3.1.1-8KBKH3EsotI2v3BWqoG8PB
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    shakespeare-2.0.25-XmCiC46vFjHOS3mqVqGwV
    split-0.2.3.4-DqRCEXcI8QnJvOh9Kk2yn3
    tabular-0.2.2.8-8JF65zbpqg3J2xw1bK6aDa
    tasty-1.4.2-1aAksKrUWCNHrjKPjUgbfA
    temporary-1.3-1fpZ6Xm8biD79YIGypkFzm terminfo-0.4.1.4 text-1.2.4.1
    time-1.9.3 timeit-2.0-IUvGmumxlJTJLVT8F6LloM transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    utility-ht-0.0.16-7zsyGPrROJK5tDhAbtdwk3
    wizards-1.0.3-L8V3kpAxPN1GYmfVO3jtn

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

