#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-iadd
version:              1.3.15
visibility:           public
id:                   hledger-iadd-1.3.15-CugfRIlv3H1A61isLiJmHX
key:                  hledger-iadd-1.3.15-CugfRIlv3H1A61isLiJmHX
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  c377fde19a0eca82ecccd55b04eeefda
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hledger-iadd-1.3.15
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hledger-iadd-1.3.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hledger-iadd-1.3.15
hs-libraries:         HShledger-iadd-1.3.15-CugfRIlv3H1A61isLiJmHX
depends:
    base-4.15.0.0 brick-0.64.1-ItoB5z7P52AJs3irl5itrE
    containers-0.6.4.1 directory-1.3.6.1
    free-5.1.7-FWBUU8xEKPX4Q9z8pw5z7Z
    hledger-lib-1.22.2-6jY4ZpE9OekqSXdufIhjB
    megaparsec-9.2.0-4jOz50swwTdC1OkC7cXk5Y
    microlens-0.4.12.0-IoK2ncpVKVzEwRUasmz5D3
    microlens-th-0.4.3.10-D8A4jvR3QXlLLaZkQUchH1
    optparse-applicative-0.16.1.0-2gAu0ltAuRsE34mFhrRUQs text-1.2.4.1
    text-zipper-0.11-HZ9wLXo6Hkt9PmkSJ5vwId time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3
    vty-5.33-DMmRK5AACmdHEsACGHpIdt
    xdg-basedir-0.2.2-FxvLd0PtCIDHWciCXDjKP6

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

