#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.22.2
visibility:           public
id:                   hledger-web-1.22.2-5ig71BEWbme2RTWq0SzKKr
key:                  hledger-web-1.22.2-5ig71BEWbme2RTWq0SzKKr
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web-based user interface for the hledger accounting system
description:
    A simple web-based user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  f5d3b7475448cf6e8b0f7d41eb78a389
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.0.1/site-local/hledger-web-1.22.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hledger-web-1.22.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.22.2-5ig71BEWbme2RTWq0SzKKr
depends:
    Decimal-0.5.2-C6RtKO4JEZBCq6iLATrwho
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S base-4.15.0.0
    blaze-html-0.9.1.2-K4t4PnwLIn1K06QqwerVVe
    blaze-markup-0.8.2.8-16j1paqjrAu4vBleBUkWjQ bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR
    clientsession-0.9.1.2-2Wzbn6cR0uiEfPXy9A0Rzx
    cmdargs-0.10.21-9JSptK8vQ5KGyQ5LWB6hlS
    conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI
    conduit-extra-1.3.5-IgmaX557TTAKniYRnNEHGm containers-0.6.4.1
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF directory-1.3.6.1
    extra-1.7.10-32H3SA4Yf8dI1sU3NgBQjm filepath-1.4.2.1
    hjsmin-0.2.0.4-r5sgLhkj248Qt5EB0sAFM
    hledger-1.22.2-HH3LAkhAuZ320qR1mBUBz5
    hledger-lib-1.22.2-6jY4ZpE9OekqSXdufIhjB
    hspec-2.8.3-KpDDh4qNyBt7FbqE4tn9gO
    http-client-0.7.9-FqmYjByM3mW7WXdqjAmvxU
    http-conduit-2.3.8-CUEm0yFAAfcJU3pZch3I0b
    http-types-0.12.3-5xSWCbzPZMJ3FKkHNvWW2m
    megaparsec-9.2.0-4jOz50swwTdC1OkC7cXk5Y mtl-2.2.2
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    shakespeare-2.0.25-XmCiC46vFjHOS3mqVqGwV template-haskell-2.17.0.0
    text-1.2.4.1 time-1.9.3 transformers-0.5.6.2
    unix-compat-0.5.3-CsWJk3UHZrh7lbWn5tdOhn
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    wai-3.2.3-5Y0o3GgLhLBDIUVnFhg417
    wai-cors-0.2.7-11ccpD9KI9FEgc0vD0zokq
    wai-extra-3.1.7-7O6xxSYSpPwLxUDTZSwbv3
    wai-handler-launch-3.0.3.1-Bg0ZR9X2A0r7djsrLDmasz
    warp-3.3.18-FG6iRvxgYKDGN1ukLWsD2N
    yaml-0.11.7.0-ELLRQJizuQ2JHzBO2jWxZf
    yesod-1.6.1.2-3NxMlV3OLN1MEzueYCGVE
    yesod-core-1.6.21.0-FWRoWQG99ej3o55ztbjIWx
    yesod-form-1.7.0-4XX1whDQa7HIT4QYnu20FJ
    yesod-static-1.6.1.0-6LKjJ5DGHYi90ZUlz7AILY
    yesod-test-1.6.12-GqLCiS0egEIF4GKPFWCbMW

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

