/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli.clst;

import jadx.api.JadxArgs;
import jadx.api.plugins.JadxPluginManager;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.core.clsp.ClsSet;
import jadx.core.dex.nodes.RootNode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToClsSet {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToClsSet.class);

    public static void usage() {
        LOG.info("<output .jcst or .jar file> <several input dex or jar files> ");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            ConvertToClsSet.usage();
            System.exit(1);
        }
        List inputPaths = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        Path output = (Path)inputPaths.remove(0);
        JadxPluginManager pluginManager = new JadxPluginManager();
        ArrayList<ILoadResult> loadedInputs = new ArrayList<ILoadResult>();
        for (JadxInputPlugin inputPlugin : pluginManager.getInputPlugins()) {
            loadedInputs.add(inputPlugin.loadFiles(inputPaths));
        }
        JadxArgs jadxArgs = new JadxArgs();
        jadxArgs.setRenameFlags(EnumSet.noneOf(JadxArgs.RenameEnum.class));
        RootNode root = new RootNode(jadxArgs);
        root.loadClasses(loadedInputs);
        ClsSet set = new ClsSet(root);
        set.loadFrom(root);
        set.save(output);
        LOG.info("Output: {}, file size: {}B", (Object)output, (Object)output.toFile().length());
        LOG.info("done");
    }
}

