/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.parser;

import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureParser {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureParser.class);
    private static final char STOP_CHAR = '\u0000';
    private final String sign;
    private final int end;
    private int pos;
    private int mark;

    public SignatureParser(String signature) {
        this.sign = signature;
        this.end = this.sign.length();
        this.pos = -1;
        this.mark = 0;
    }

    @Nullable
    public static SignatureParser fromNode(IAttributeNode node) {
        String signature = SignatureParser.getSignature(node);
        if (signature == null) {
            return null;
        }
        return new SignatureParser(signature);
    }

    @Nullable
    public static String getSignature(IAttributeNode node) {
        IAnnotation a = node.getAnnotation("Ldalvik/annotation/Signature;");
        if (a == null) {
            return null;
        }
        List values = (List)a.getDefaultValue().getValue();
        List<String> strings = Utils.collectionMap(values, ev -> (String)ev.getValue());
        return SignatureParser.mergeSignature(strings);
    }

    private char next() {
        ++this.pos;
        if (this.pos >= this.end) {
            return '\u0000';
        }
        return this.sign.charAt(this.pos);
    }

    private boolean lookAhead(char ch) {
        int next = this.pos + 1;
        return next < this.end && this.sign.charAt(next) == ch;
    }

    private void mark() {
        this.mark = this.pos;
    }

    private String slice() {
        int start;
        int n = start = this.mark == -1 ? 0 : this.mark;
        if (start >= this.pos) {
            return "";
        }
        return this.sign.substring(start, this.pos);
    }

    private String inclusiveSlice() {
        int last;
        int start = this.mark;
        if (start == -1) {
            start = 0;
        }
        if (start >= (last = this.pos + 1)) {
            return "";
        }
        return this.sign.substring(start, last);
    }

    private boolean skipUntil(char untilChar) {
        char ch;
        int startPos = this.pos;
        do {
            if (!this.lookAhead(untilChar)) continue;
            return true;
        } while ((ch = this.next()) != '\u0000');
        this.pos = startPos;
        return false;
    }

    private void consume(char exp) {
        char c = this.next();
        if (exp != c) {
            throw new JadxRuntimeException("Consume wrong char: '" + c + "' != '" + exp + "', sign: " + this.debugString());
        }
    }

    private boolean tryConsume(char exp) {
        if (this.lookAhead(exp)) {
            this.next();
            return true;
        }
        return false;
    }

    @Nullable
    public String consumeUntil(char lastChar) {
        this.mark();
        return this.skipUntil(lastChar) ? this.inclusiveSlice() : null;
    }

    public ArgType consumeType() {
        char ch = this.next();
        switch (ch) {
            case 'L': {
                ArgType obj = this.consumeObjectType(false);
                if (obj == null) break;
                return obj;
            }
            case 'T': {
                this.next();
                this.mark();
                String typeVarName = this.consumeUntil(';');
                if (typeVarName == null) break;
                this.consume(';');
                if (typeVarName.contains(")")) {
                    throw new JadxRuntimeException("Bad name for type variable: " + typeVarName);
                }
                return ArgType.genericType(typeVarName);
            }
            case '[': {
                return ArgType.array(this.consumeType());
            }
            case '\u0000': {
                return null;
            }
            default: {
                ArgType type = ArgType.parse(ch);
                if (type == null) break;
                return type;
            }
        }
        throw new JadxRuntimeException("Can't parse type: " + this.debugString() + ", unexpected: " + ch);
    }

    private ArgType consumeObjectType(boolean innerType) {
        char ch;
        this.mark();
        do {
            if (innerType && this.lookAhead('.')) {
                return ArgType.object(this.inclusiveSlice());
            }
            ch = this.next();
            if (ch != '\u0000') continue;
            return null;
        } while (ch != '<' && ch != ';');
        if (ch == ';') {
            String obj = innerType ? this.slice().replace('/', '.') : this.inclusiveSlice();
            return ArgType.object(obj);
        }
        String obj = this.slice();
        if (!innerType) {
            obj = obj + ';';
        }
        List<ArgType> typeVars = this.consumeGenericArgs();
        this.consume('>');
        ArgType genericType = ArgType.generic(obj, typeVars);
        if (!this.lookAhead('.')) {
            this.consume(';');
            return genericType;
        }
        this.consume('.');
        this.next();
        ArgType inner = this.consumeObjectType(true);
        if (inner == null) {
            throw new JadxRuntimeException("No inner type found: " + this.debugString());
        }
        while (this.lookAhead('.')) {
            genericType = ArgType.outerGeneric(genericType, inner);
            this.consume('.');
            this.next();
            inner = this.consumeObjectType(true);
            if (inner != null) continue;
            throw new JadxRuntimeException("Unexpected inner type found: " + this.debugString());
        }
        return ArgType.outerGeneric(genericType, inner);
    }

    private List<ArgType> consumeGenericArgs() {
        ArgType type;
        LinkedList<ArgType> list = new LinkedList<ArgType>();
        do {
            if (this.lookAhead('*')) {
                this.next();
                type = ArgType.wildcard();
            } else if (this.lookAhead('+')) {
                this.next();
                type = ArgType.wildcard(this.consumeType(), ArgType.WildcardBound.EXTENDS);
            } else if (this.lookAhead('-')) {
                this.next();
                type = ArgType.wildcard(this.consumeType(), ArgType.WildcardBound.SUPER);
            } else {
                type = this.consumeType();
            }
            if (type == null) continue;
            list.add(type);
        } while (type != null && !this.lookAhead('>'));
        return list;
    }

    public List<ArgType> consumeGenericTypeParameters() {
        if (!this.lookAhead('<')) {
            return Collections.emptyList();
        }
        ArrayList<ArgType> list = new ArrayList<ArgType>();
        this.consume('<');
        while (!this.lookAhead('>') && this.next() != '\u0000') {
            String id = this.consumeUntil(':');
            if (id == null) {
                throw new JadxRuntimeException("Failed to parse generic types map");
            }
            this.consume(':');
            this.tryConsume(':');
            List<ArgType> types = this.consumeExtendsTypesList();
            list.add(ArgType.genericType(id, types));
        }
        this.consume('>');
        return list;
    }

    private List<ArgType> consumeExtendsTypesList() {
        boolean next;
        List<ArgType> types = Collections.emptyList();
        do {
            ArgType argType;
            if ((argType = this.consumeType()) == null) {
                throw new JadxRuntimeException("Unexpected end of signature");
            }
            if (!argType.equals(ArgType.OBJECT)) {
                if (types.isEmpty()) {
                    types = new ArrayList();
                }
                types.add(argType);
            }
            if (!(next = this.lookAhead(':'))) continue;
            this.consume(':');
        } while (next);
        return types;
    }

    public List<ArgType> consumeMethodArgs(int argsCount) {
        this.consume('(');
        if (this.lookAhead(')')) {
            this.consume(')');
            return Collections.emptyList();
        }
        ArrayList<ArgType> args = new ArrayList<ArgType>(argsCount);
        int limit = argsCount + 10;
        do {
            ArgType type;
            if ((type = this.consumeType()) == null) {
                throw new JadxRuntimeException("Unexpected end of signature");
            }
            args.add(type);
            if (args.size() <= limit) continue;
            throw new JadxRuntimeException("Arguments count limit reached: " + args.size());
        } while (!this.lookAhead(')'));
        this.consume(')');
        return args;
    }

    private static String mergeSignature(List<String> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
        }
        return sb.toString();
    }

    public String getSignature() {
        return this.sign;
    }

    private String debugString() {
        if (this.pos >= this.sign.length()) {
            return this.sign;
        }
        return this.sign + " at position " + this.pos + " ('" + this.sign.charAt(this.pos) + "')";
    }

    public String toString() {
        if (this.pos == -1) {
            return this.sign;
        }
        return this.sign.substring(0, this.mark) + '{' + this.sign.substring(this.mark, this.pos) + '}' + this.sign.substring(this.pos);
    }
}

