/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;

public class ListenerList<T> {
    private final CopyOnWriteArrayList<T> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WeakListener<T>> weakListeners = new CopyOnWriteArrayList();

    protected ListenerList() {
    }

    public synchronized void addWeakListener(T listener) {
        if (this.ensureNotInList(listener)) {
            while (this.weakListeners.remove(new WeakListener<Object>(null))) {
            }
            this.weakListeners.add(new WeakListener<T>(listener));
        }
    }

    public synchronized void addListener(T listener) {
        if (this.ensureNotInList(listener)) {
            this.listeners.add(listener);
        }
    }

    private boolean ensureNotInList(T listener) {
        CheckParameterUtil.ensureParameterNotNull(listener, "listener");
        if (this.containsListener(listener)) {
            this.failAdd(listener);
            return false;
        }
        return true;
    }

    protected void failAdd(T listener) {
        throw new IllegalArgumentException(MessageFormat.format("Listener {0} (instance of {1}) was already registered.", listener, listener.getClass().getName()));
    }

    public synchronized boolean containsListener(T listener) {
        return this.listeners.contains(listener) || this.weakListeners.contains(new WeakListener<T>(listener));
    }

    public synchronized void removeListener(T listener) {
        if (!this.listeners.remove(listener) && !this.weakListeners.remove(new WeakListener<T>(listener))) {
            this.failRemove(listener);
        }
    }

    protected void failRemove(T listener) {
        throw new IllegalArgumentException(MessageFormat.format("Listener {0} (instance of {1}) was not registered before or already removed.", listener, listener.getClass().getName()));
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void fireEvent(EventFirerer<T> eventFirerer) {
        for (T t : this.listeners) {
            eventFirerer.fire(t);
        }
        for (WeakListener weakListener : this.weakListeners) {
            Object l = weakListener.listener.get();
            if (l == null) continue;
            eventFirerer.fire(l);
        }
    }

    public static <T> ListenerList<T> create() {
        if (Logging.isTraceEnabled()) {
            return new TracingListenerList();
        }
        return new ListenerList<T>();
    }

    public static <T> ListenerList<T> createUnchecked() {
        return new UncheckedListenerList();
    }

    private static class UncheckedListenerList<T>
    extends ListenerList<T> {
        private UncheckedListenerList() {
        }

        @Override
        protected void failAdd(T listener) {
            Logging.warn("Listener was already added: {0}", listener);
        }

        @Override
        protected void failRemove(T listener) {
            Logging.warn("Listener was removed twice or not added: {0}", listener);
        }
    }

    public static class TracingListenerList<T>
    extends ListenerList<T> {
        private final HashMap<T, StackTraceElement[]> listenersAdded = new HashMap();
        private final HashMap<T, StackTraceElement[]> listenersRemoved = new HashMap();

        protected TracingListenerList() {
        }

        @Override
        public synchronized void addListener(T listener) {
            super.addListener(listener);
            this.listenersRemoved.remove(listener);
            this.listenersAdded.put(listener, Thread.currentThread().getStackTrace());
        }

        @Override
        public synchronized void addWeakListener(T listener) {
            super.addWeakListener(listener);
            this.listenersRemoved.remove(listener);
            this.listenersAdded.put(listener, Thread.currentThread().getStackTrace());
        }

        @Override
        public synchronized void removeListener(T listener) {
            super.removeListener(listener);
            this.listenersAdded.remove(listener);
            this.listenersRemoved.put(listener, Thread.currentThread().getStackTrace());
        }

        @Override
        protected void failAdd(T listener) {
            Logging.trace("Previous addition of the listener");
            TracingListenerList.dumpStack(this.listenersAdded.get(listener));
            super.failAdd(listener);
        }

        @Override
        protected void failRemove(T listener) {
            Logging.trace("Previous removal of the listener");
            TracingListenerList.dumpStack(this.listenersRemoved.get(listener));
            super.failRemove(listener);
        }

        private static void dumpStack(StackTraceElement ... stackTraceElements) {
            if (stackTraceElements == null) {
                Logging.trace("  - (no trace recorded)");
            } else {
                Stream.of(stackTraceElements).limit(20L).forEach(e -> Logging.trace(e.getClassName() + "." + e.getMethodName() + " line " + e.getLineNumber()));
            }
        }
    }

    private static final class WeakListener<T> {
        private final WeakReference<T> listener;

        WeakListener(T listener) {
            this.listener = new WeakReference<T>(listener);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == WeakListener.class) {
                return Objects.equals(this.listener.get(), ((WeakListener)obj).listener.get());
            }
            return false;
        }

        public int hashCode() {
            Object l = this.listener.get();
            if (l == null) {
                return 0;
            }
            return l.hashCode();
        }

        public String toString() {
            return "WeakListener [listener=" + this.listener + ']';
        }
    }

    @FunctionalInterface
    public static interface EventFirerer<T> {
        public void fire(T var1);
    }
}

