/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.storage.SearchableModelField;

public class QueryParameters<M> {
    private Integer offset;
    private Integer limit;
    private final List<OrderBy<M>> orderBy = new LinkedList<OrderBy<M>>();
    private ModelCriteriaBuilder<M> mcb;

    public QueryParameters() {
    }

    public QueryParameters(ModelCriteriaBuilder<M> mcb) {
        this.mcb = mcb;
    }

    public static <M> QueryParameters<M> withCriteria(ModelCriteriaBuilder<M> mcb) {
        return new QueryParameters<M>(mcb);
    }

    public QueryParameters<M> pagination(Integer offset, Integer limit, SearchableModelField<M> orderByAscField) {
        this.offset = offset;
        this.limit = limit;
        this.orderBy.add(new OrderBy<M>(orderByAscField, Order.ASCENDING));
        return this;
    }

    public QueryParameters<M> orderBy(SearchableModelField<M> searchableModelField, Order order) {
        this.orderBy.add(new OrderBy<M>(searchableModelField, order));
        return this;
    }

    public QueryParameters<M> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public QueryParameters<M> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ModelCriteriaBuilder<M> getModelCriteriaBuilder() {
        return this.mcb;
    }

    public List<OrderBy<M>> getOrderBy() {
        return this.orderBy;
    }

    public static class OrderBy<M> {
        private final SearchableModelField<M> modelField;
        private final Order order;

        public OrderBy(SearchableModelField<M> modelField, Order order) {
            this.modelField = modelField;
            this.order = order;
        }

        public SearchableModelField<M> getModelField() {
            return this.modelField;
        }

        public Order getOrder() {
            return this.order;
        }
    }

    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

