/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

abstract class AbstractWebAuthnContext
implements Serializable {
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final ServerProperty serverProperty;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;
    private final List<String> expectedExtensionIds;

    AbstractWebAuthnContext(byte[] clientDataJSON, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired, List<String> expectedExtensionIds) {
        this.clientDataJSON = clientDataJSON;
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.serverProperty = serverProperty;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
        this.expectedExtensionIds = CollectionUtil.unmodifiableList(expectedExtensionIds);
    }

    public byte[] getClientDataJSON() {
        return ArrayUtil.clone((byte[])this.clientDataJSON);
    }

    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public List<String> getExpectedExtensionIds() {
        return this.expectedExtensionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractWebAuthnContext that = (AbstractWebAuthnContext)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.expectedExtensionIds, that.expectedExtensionIds);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON, this.serverProperty, this.userVerificationRequired, this.userPresenceRequired, this.expectedExtensionIds);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        return result;
    }
}

