/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum AuthenticatorAttachment {
    PLATFORM("platform"),
    CROSS_PLATFORM("cross-platform");

    private final String value;

    private AuthenticatorAttachment(String value) {
        this.value = value;
    }

    public static AuthenticatorAttachment create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "platform": {
                return PLATFORM;
            }
            case "cross-platform": {
                return CROSS_PLATFORM;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static AuthenticatorAttachment deserialize(String value) throws InvalidFormatException {
        try {
            return AuthenticatorAttachment.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticatorAttachment.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

