/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.wildfly;

import java.io.File;
import org.jboss.logging.Logger;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.services.ServicesLogger;

public class WildflyPlatform
implements PlatformProvider {
    private static final Logger log = Logger.getLogger(WildflyPlatform.class);
    Runnable shutdownHook;
    private File tmpDir;

    public void onStartup(Runnable startupHook) {
        startupHook.run();
    }

    public void onShutdown(Runnable shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public void exit(Throwable cause) {
        ServicesLogger.LOGGER.fatal((Object)"Error during startup", cause);
        this.exit(1);
    }

    private void exit(final int status) {
        new Thread(){

            @Override
            public void run() {
                System.exit(status);
            }
        }.start();
    }

    public File getTmpDirectory() {
        if (this.tmpDir == null) {
            String tmpDirName = System.getProperty("jboss.server.temp.dir");
            if (tmpDirName == null) {
                throw new RuntimeException("System property jboss.server.temp.dir not set");
            }
            File tmpDir = new File(tmpDirName);
            if (tmpDir.isDirectory()) {
                this.tmpDir = tmpDir;
                log.debugf("Using server tmp directory: %s", (Object)tmpDir.getAbsolutePath());
            } else {
                throw new RuntimeException("Wildfly temp directory not exists under path: " + tmpDirName);
            }
        }
        return this.tmpDir;
    }
}

