/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate13_0_0_MigrateDefaultRoles
extends CustomKeycloakTask {
    private final Set<String> realmIds = new HashSet<String>();

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.extractRealmIds("SELECT ID FROM " + this.getTableName("REALM"));
        String clientTable = this.getTableName("CLIENT");
        String clientDefaultRolesTable = this.getTableName("CLIENT_DEFAULT_ROLES");
        String compositeRoleTable = this.getTableName("COMPOSITE_ROLE");
        for (String realmId : this.realmIds) {
            String id = UUID.randomUUID().toString();
            String roleName = this.determineDefaultRoleName(realmId);
            this.statements.add(new InsertStatement(null, null, this.database.correctObjectName("KEYCLOAK_ROLE", Table.class)).addColumnValue("ID", (Object)id).addColumnValue("CLIENT_REALM_CONSTRAINT", (Object)realmId).addColumnValue("CLIENT_ROLE", (Object)Boolean.FALSE).addColumnValue("DESCRIPTION", (Object)("${role_" + roleName + "}")).addColumnValue("NAME", (Object)roleName).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("REALM", (Object)realmId));
            this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("REALM", Table.class)).addNewColumnValue("DEFAULT_ROLE", (Object)id).setWhereClause("REALM.ID=?").addWhereParameter((Object)realmId));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', ROLE_ID FROM " + this.getTableName("REALM_DEFAULT_ROLES") + " WHERE REALM_ID = '" + this.database.escapeStringForDatabase(realmId) + "'"));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', " + clientDefaultRolesTable + ".ROLE_ID FROM " + clientDefaultRolesTable + " INNER JOIN " + clientTable + " ON " + clientTable + ".ID = " + clientDefaultRolesTable + ".CLIENT_ID AND " + clientTable + ".REALM_ID = '" + this.database.escapeStringForDatabase(realmId) + "'"));
        }
    }

    private void extractRealmIds(String sql) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                this.realmIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    private String determineDefaultRoleName(String realmId) throws CustomChangeException {
        String roleName = "default-roles-" + realmId.toLowerCase();
        if (this.isRoleNameAvailable(realmId, roleName)) {
            return roleName;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            roleName = "default-roles-" + realmId.toLowerCase() + "-" + i;
            if (!this.isRoleNameAvailable(realmId, roleName)) continue;
            return roleName;
        }
        throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version. Unable to determine default role name.");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isRoleNameAvailable(String realmId, String roleName) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("SELECT ID FROM " + this.getTableName("KEYCLOAK_ROLE") + " WHERE REALM_ID=? AND NAME=?");){
            boolean bl;
            block14: {
                statement.setString(1, realmId);
                statement.setString(2, roleName);
                ResultSet rs = statement.executeQuery();
                try {
                    boolean bl2 = bl = !rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Migrate Default roles (13.0.0)";
    }
}

