/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import java.io.IOException;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;

public class ElytronAuthenticationMarshaller
implements ProtoStreamMarshaller<ElytronAuthentication> {
    private static final int MECHANISM_INDEX = 1;
    private static final int NON_PROGRAMMIC_NAME_INDEX = 2;
    private static final int PROGRAMMATIC_NAME_INDEX = 3;
    private static final String DEFAULT_MECHANISM = "FORM";

    public ElytronAuthentication readFrom(ProtoStreamReader reader) throws IOException {
        String mechanism = DEFAULT_MECHANISM;
        String name = null;
        boolean programmatic = false;
        boolean reading = true;
        block5: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    mechanism = reader.readString();
                    continue block5;
                }
                case 3: {
                    programmatic = true;
                }
                case 2: {
                    name = reader.readString();
                    continue block5;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new ElytronAuthentication(mechanism, programmatic, name);
    }

    public void writeTo(ProtoStreamWriter writer, ElytronAuthentication auth) throws IOException {
        String name;
        String mechanism = auth.getMechanism();
        if (!mechanism.equals(DEFAULT_MECHANISM)) {
            writer.writeString(1, mechanism);
        }
        if ((name = auth.getName()) != null) {
            writer.writeString(auth.isProgrammatic() ? 3 : 2, name);
        }
    }

    public Class<? extends ElytronAuthentication> getJavaClass() {
        return ElytronAuthentication.class;
    }
}

