/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ClassField;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.LoadedClassField;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ClassMarshaller
implements ProtoStreamMarshaller<Class<?>> {
    private final Field<Class<?>> field;

    public ClassMarshaller(ClassLoaderMarshaller marshaller) {
        ClassField[] fields = ClassField.values();
        this.field = new LoadedClassField(marshaller, fields[fields.length - 1].getIndex() + 1);
    }

    @Override
    public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
        Class result = Object.class;
        int tag = reader.readTag();
        if (tag != 0) {
            int index = WireFormat.getTagFieldNumber((int)tag);
            ClassField field = index == this.field.getIndex() ? this.field : ClassField.fromIndex(index);
            result = (Class)field.getMarshaller().readFrom(reader);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Class<?> targetClass) throws IOException {
        if (targetClass != Object.class) {
            Field<Class<?>> field = this.getField(writer.getSerializationContext(), targetClass);
            writer.writeTag(field.getIndex(), field.getMarshaller().getWireType());
            field.getMarshaller().writeTo(writer, targetClass);
        }
    }

    Field<Class<?>> getField(ImmutableSerializationContext context, Class<?> targetClass) {
        AnyField classField = AnyField.fromJavaType(targetClass);
        if (classField != null) {
            return ClassField.FIELD;
        }
        if (targetClass.isArray()) {
            return ClassField.ARRAY;
        }
        try {
            BaseMarshaller marshaller = context.getMarshaller(targetClass);
            if (marshaller.getJavaClass() != targetClass) {
                return this.field;
            }
            return context.getDescriptorByName(marshaller.getTypeName()).getTypeId() != null ? ClassField.ID : ClassField.NAME;
        }
        catch (IllegalArgumentException e) {
            return this.field;
        }
    }

    @Override
    public Class<? extends Class<?>> getJavaClass() {
        return this.field.getMarshaller().getJavaClass();
    }
}

