/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.ServerMacSignatureSignerContext;
import org.keycloak.crypto.ServerMacSignatureVerifierContext;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.models.KeycloakSession;

public class MacSecretSignatureProvider
implements SignatureProvider {
    private final KeycloakSession session;
    private final String algorithm;

    public MacSecretSignatureProvider(KeycloakSession session, String algorithm) {
        this.session = session;
        this.algorithm = algorithm;
    }

    public SignatureSignerContext signer() throws SignatureException {
        return new ServerMacSignatureSignerContext(this.session, this.algorithm);
    }

    public SignatureVerifierContext verifier(String kid) throws VerificationException {
        return new ServerMacSignatureVerifierContext(this.session, kid, this.algorithm);
    }

    public boolean isAsymmetricAlgorithm() {
        return false;
    }
}

